# Camera Roll Bin Creator for DaVinci Resolve  
**by Daniel Bañuelos | More tools at [dandbc.mx/tools](https://dandbc.mx/tools)**

## 📋 Overview
This script generates **camera roll-style bins** inside the DaVinci Resolve Media Pool using a simple dialog. It allows assistant editors and DITs to quickly create structured bin hierarchies like:

```
A001  
A002  
A003  
...
```

Perfect for **on-set dailies organization**, **postproduction prep**, or **DIT workflows**, where naming consistency and speed are critical.

## 🚀 Features
- **Automatic Bin Creation:** Instantly generates sequentially named bins.
- **Custom Start Index:** Start numbering from any number (e.g., begin at `A101`).
- **Single-Letter Prefix Control:** Set the camera index letter (A, B, C...).
- **Zero-Padded Numbering:** Choose the amount of digits (`A001`, `A0001`, etc.).
- **Safe Undo:** Wrapped in a Resolve undo group where supported.

## 🎯 Ideal Use Cases
- **DIT station setup before ingest**
- **Editorial prep for multi-day shoots**
- **Organizing camera cards per day/scene**
- **Naming consistency for shared postproduction workflows**

## 🛠️ Usage
1. Place the script in:
   ```
   DaVinci Resolve > Fusion > Scripts > Edit
   ```
2. In Resolve, open **Media Pool** and **select the parent bin** where you want the bins created.
3. Go to **Workspace → Scripts → Edit → Camera Roll Bin Creator**.
4. Enter:
   - **How many bins to create**
   - **Digit padding (e.g., 3 = A001)**
   - **Starting index (e.g., 5 → A005)**
   - **Prefix letter (e.g., A)**
5. Click **OK** — the bins will be generated instantly.

## 📦 Example Output
If you set:
- Letter: `B`  
- Digits: `3`  
- Count: `5`  
- Start Index: `101`

The script will create:

```
B101  
B102  
B103  
B104  
B105
```

## 💡 Notes
- If a bin already exists with the same name, it will be skipped safely.
- The script creates bins **inside the currently selected Media Pool folder** — if nothing is selected, it defaults to **Root**.
- Naming conventions are based on standard **camera card naming workflows** (A001, B002, etc.).

## ⚖️ Disclaimer
This script was developed with the assistance of **ChatGPT-5** and refined by **Daniel Bañuelos**. While tested in professional environments, **always confirm bin structures before committing to a dailies pipeline or shared project**.

## 👋 About the Author
**Daniel Bañuelos** — Postproduction Supervisor, Educator & Workflow Designer  
- **Website:** [dandbc.mx/tools](https://dandbc.mx/tools)  
- **LinkedIn:** [linkedin.com/in/danielbanuelos](https://linkedin.com/in/danielbanuelos)  
- **Email:** dany.b@dandbc.mx  

---

🎬 *Want custom DaVinci Resolve scripts or pipeline automation?*  
Reach out at **dany.b@dandbc.mx** — Let’s build better workflows. 🚀
